//		offscreen_manager.h

#ifndef	_offscreen_manager_
#define _offscreen_manager_

#define	_H_offscreen_manager

#ifndef __GNUC__
	#include "QDOffscreen.h"
#endif

typedef	struct	{
	CGrafPtr	port;
	GDHandle	device;
} PortAndDevice;

#define		k_pixel_purgeable		0x00000001

#define		ForgetGWorld(x)		((x) ? (DisposeGWorld(x), x = NULL) : 0)
//	or		do { if (x) { DisposeGWorld(x); x=NULL; } } while (0)

void		DrawPict(GWorldPtr theOffscreen, short h, short v);
void		DrawPictWithMask(GWorldPtr theOffscreen, GWorldPtr theMask, short h, short v);

GWorldPtr	PICT_to_offscreen(PicHandle thePICT, int depth);

GWorldPtr	CreateWindowOffscreen(WindowPtr theWindow, short pixelDepth, long options);

int			UpdateWindowOffscreen(WindowPtr theWindow, GWorldPtr *offscreenPtr,
									short pixelDepth, GWorldFlags flags);

GWorldPtr	CreateOffscreen(Rect Size, short pixelDepth, long options);

int			EraseOffscreen(GWorldPtr offscreenPtr);

GWorldPtr	CreateOffscreenWithCTab(Rect Size, short pixelDepth, CTabHandle cTab, long options);

void		DisposeOffscreen(GWorldPtr OffscreenPtr);

int			CopyFromOffscreen(	WindowPtr theWindow, Rect *srcRect,
								GWorldPtr offscreenPtr, Rect *destRect);

int			CopyRgnFromOffscreen(	WindowPtr theWindow, RgnHandle theRgn,
								GWorldPtr offscreenPtr);

int			CopyOffscreenToOffscreen(	GWorldPtr srcOffscreen, Rect *srcRect,
										GWorldPtr destOffscreen, Rect *destRect);

void	GetPortAndDevice(PortAndDevice *savedPortAndDevice);

void	SetPortAndDevice(PortAndDevice *savedPortAndDevice);

Boolean		DrawOffscreen(
	GWorldPtr		theOffscreen, 
	PortAndDevice	*savePD, 
	GWorldFlags		*pixState);

void		StopDrawingOffscreen(
	GWorldPtr		theOffscreen, 
	PortAndDevice	*savePD, 
	GWorldFlags		*pixState);

int		UseOffscreen(GWorldPtr OffscreenPtr, GWorldFlags *pixState);

void	StopUsingOffscreen(GWorldPtr OffscreenPtr, GWorldFlags *pixState);

int		CheckOffscreenPixMap(GWorldPtr OffscreenPtr);

#endif
